#IFNDEF __GLIB_H_INSIDE__
#ERROR "Only <glib.bi> can be included directly."
#ENDIF ' __GLIB_H_INSIDE__

#IFNDEF __G_LIBCONFIG_H__
#DEFINE __G_LIBCONFIG_H__

#INCLUDE ONCE "crt/limits.bi" '__HEADERS__: limits.h

#IF DEFINED(__FB_UNIX__)
#DEFINE GLIB_HAVE_ALLOCA_H
#DEFINE GLIB_HAVE_SYS_POLL_H
#DEFINE GLIB_USING_SYSTEM_PRINTF
#ENDIF

#DEFINE G_MINFLOAT FLT_MIN
#DEFINE G_MAXFLOAT FLT_MAX
#DEFINE G_MINDOUBLE DBL_MIN
#DEFINE G_MAXDOUBLE DBL_MAX
#DEFINE G_MINSHORT SHRT_MIN
#DEFINE G_MAXSHORT SHRT_MAX
#DEFINE G_MAXUSHORT USHRT_MAX
#DEFINE G_MININT INT_MIN
#DEFINE G_MAXINT INT_MAX
#DEFINE G_MAXUINT UINT_MAX
#DEFINE G_MINLONG LONG_MIN
#DEFINE G_MAXLONG LONG_MAX
#DEFINE G_MAXULONG ULONG_MAX

TYPE gint8 AS BYTE
TYPE guint8 AS UBYTE
TYPE gint16 AS SHORT
TYPE guint16 AS USHORT

#DEFINE G_GINT16_MODIFIER !"h"
#DEFINE G_GINT16_FORMAT !"hi"
#DEFINE G_GUINT16_FORMAT !"hu"

TYPE gint32 AS INTEGER
TYPE guint32 AS UINTEGER

#DEFINE G_GINT32_MODIFIER !""
#DEFINE G_GINT32_FORMAT !"i"
#DEFINE G_GUINT32_FORMAT !"u"
#DEFINE G_HAVE_GINT64 1

TYPE gint64 AS LONGINT
TYPE guint64 AS ULONGINT

#DEFINE G_GINT64_CONSTANT(val) (G_GNUC_EXTENSION (val##LL))
#DEFINE G_GUINT64_CONSTANT(val) (G_GNUC_EXTENSION (val##ULL))
#DEFINE G_GINT64_MODIFIER !"ll"
#DEFINE G_GINT64_FORMAT !"lli"
#DEFINE G_GUINT64_FORMAT !"llu"
#DEFINE GLIB_SIZEOF_VOID_P 4
#DEFINE GLIB_SIZEOF_LONG 4
#DEFINE GLIB_SIZEOF_SIZE_T 4

TYPE gssize AS INTEGER
TYPE gsize AS UINTEGER

#DEFINE G_GSIZE_MODIFIER !""
#DEFINE G_GSSIZE_FORMAT !"i"
#DEFINE G_GSIZE_FORMAT !"u"
#DEFINE G_MAXSIZE G_MAXUINT
#DEFINE G_MINSSIZE G_MININT
#DEFINE G_MAXSSIZE G_MAXINT

TYPE goffset AS gint64

#DEFINE G_MINOFFSET G_MININT64
#DEFINE G_MAXOFFSET G_MAXINT64
#DEFINE G_GOFFSET_MODIFIER G_GINT64_MODIFIER
#DEFINE G_GOFFSET_FORMAT G_GINT64_FORMAT
#DEFINE G_GOFFSET_CONSTANT(val) G_GINT64_CONSTANT(val)
#DEFINE GPOINTER_TO_INT(p) CAST(gint, p)
#DEFINE GPOINTER_TO_UINT(p) CAST(guint, p)
#DEFINE GINT_TO_POINTER(i) CAST(gpointer, CAST(gint, i))
#DEFINE GUINT_TO_POINTER(u) CAST(gpointer, CAST(guint, u))

TYPE gintptr AS INTEGER
TYPE guintptr AS UINTEGER

#DEFINE G_GINTPTR_MODIFIER !""
#DEFINE G_GINTPTR_FORMAT !"i"
#DEFINE G_GUINTPTR_FORMAT !"u"

#DEFINE g_ATEXIT(proc) (atexit (proc))

#DEFINE g_memmove(dest,src,len) memmove ((dest), (src), (len))

#DEFINE GLIB_MAJOR_VERSION 2
#DEFINE GLIB_MINOR_VERSION 31
#DEFINE GLIB_MICRO_VERSION 4

#IF DEFINED(__FB_UNIX__)
 #DEFINE G_OS_UNIX
#ELSE
 #DEFINE G_OS_WIN32
 #DEFINE G_PLATFORM_WIN32
#ENDIF

#DEFINE G_VA_COPY va_copy

#IF __FB_VERSION__ >= "0.22"
#DEFINE G_HAVE_GNUC_VARARGS 1
#ENDIF

#DEFINE G_GNUC_INTERNAL
#DEFINE G_THREADS_ENABLED

#IF DEFINED(__FB_UNIX__)
 #DEFINE G_THREADS_IMPL_POSIX
 #DEFINE G_HAVE_GROWING_STACK 1
#ELSE
 #DEFINE G_THREADS_IMPL_WIN32
#ENDIF

#DEFINE G_ATOMIC_LOCK_FREE
#DEFINE GINT16_TO_LE(val) CAST(gint16, (val))
#DEFINE GUINT16_TO_LE(val) CAST(guint16, (val))
#DEFINE GINT16_TO_BE(val) CAST(gint16, GUINT16_SWAP_LE_BE (val))
#DEFINE GUINT16_TO_BE(val) (GUINT16_SWAP_LE_BE (val))
#DEFINE GINT32_TO_LE(val) CAST(gint32, (val))
#DEFINE GUINT32_TO_LE(val) CAST(guint32, (val))
#DEFINE GINT32_TO_BE(val) CAST(gint32, GUINT32_SWAP_LE_BE (val))
#DEFINE GUINT32_TO_BE(val) (GUINT32_SWAP_LE_BE (val))
#DEFINE GINT64_TO_LE(val) CAST(gint64, (val))
#DEFINE GUINT64_TO_LE(val) CAST(guint64, (val))
#DEFINE GINT64_TO_BE(val) CAST(gint64, GUINT64_SWAP_LE_BE (val))
#DEFINE GUINT64_TO_BE(val) (GUINT64_SWAP_LE_BE (val))
#DEFINE GLONG_TO_LE(val) CAST(glong, GINT32_TO_LE (val))
#DEFINE GULONG_TO_LE(val) CAST(gulong, GUINT32_TO_LE (val))
#DEFINE GLONG_TO_BE(val) CAST(glong, GINT32_TO_BE (val))
#DEFINE GULONG_TO_BE(val) CAST(gulong, GUINT32_TO_BE (val))
#DEFINE GINT_TO_LE(val) CAST(gint, GINT32_TO_LE (val))
#DEFINE GUINT_TO_LE(val) CAST(guint, GUINT32_TO_LE (val))
#DEFINE GINT_TO_BE(val) CAST(gint, GINT32_TO_BE (val))
#DEFINE GUINT_TO_BE(val) CAST(guint, GUINT32_TO_BE (val))
#DEFINE GSIZE_TO_LE(val) CAST(gsize, GUINT32_TO_LE (val))
#DEFINE GSSIZE_TO_LE(val) CAST(gssize, GINT32_TO_LE (val))
#DEFINE GSIZE_TO_BE(val) CAST(gsize, GUINT32_TO_BE (val))
#DEFINE GSSIZE_TO_BE(val) CAST(gssize, GINT32_TO_BE (val))
#DEFINE G_BYTE_ORDER G_LITTLE_ENDIAN
#DEFINE GLIB_SYSDEF_POLLIN =1
#DEFINE GLIB_SYSDEF_POLLOUT =4
#DEFINE GLIB_SYSDEF_POLLPRI =2
#DEFINE GLIB_SYSDEF_POLLHUP =16
#DEFINE GLIB_SYSDEF_POLLERR =8
#DEFINE GLIB_SYSDEF_POLLNVAL =32

#IF DEFINED(__FB_UNIX__)
 #DEFINE G_MODULE_SUFFIX !"so"
 #DEFINE GLIB_SYSDEF_AF_INET6 10
#ELSE
 #DEFINE G_MODULE_SUFFIX !"dll"
 #DEFINE GLIB_SYSDEF_AF_INET6 23
#ENDIF

TYPE GPid AS INTEGER

#DEFINE GLIB_SYSDEF_AF_UNIX 1
#DEFINE GLIB_SYSDEF_AF_INET 2
#DEFINE GLIB_SYSDEF_MSG_OOB 1
#DEFINE GLIB_SYSDEF_MSG_PEEK 2
#DEFINE GLIB_SYSDEF_MSG_DONTROUTE 4

#ENDIF ' __G_LIBCONFIG_H__
