' coding: UTF-8
' This is file
#DEFINE PROG_NAME "h_2_bi" '.bas
' Version
#DEFINE PROG_VERS "0.2.1.1"
'
' h_2_bi translates one or more  C headers into a FreeBasic-Header
' (and generates a file 'xx_test.bas' to test the resulting FB-Header).
' Find a detailed description in ReadMe.txt or LiesMich.txt.
'
' Copyright (C) 2010 by Thomas.Freiherr{ at }gmx[ dot ]net
'
' Licence (GPLv3):
'
' h_2_bi.bas is free software: you can redistribute
' it and/or modify it under the terms of the GNU General Public
' license as published by the Free Software Foundation, either
' version 3 of the license, or (at your option) any later
' version. For details please refer to:
' http://www.gnu.org/licenses/gpl-3.0.html
'
' h_2_bi.bas is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

' The .bi files may contain var length arrays, so use fbc >0.21 at least!
#IF NOT __FB_MIN_VERSION__(0, 21, 0)
 #ERROR This code must NOT be compiled with fbc < 0.21
#ELSEIF __FB_VERSION__ <> "0.23.0"
 #PRINT PROG_NAME warning:
 #PRINT __FB_VERSION__ fbc-version in use, code developed and tested with fbc 0.23.0
#ENDIF

#IFDEF __FB_UNIX__
 #DEFINE H2BI_TARGET "UNIX/LINUX"
 #DEFINE H2BI_BINARY "./" & PROG_NAME
#ELSE
 #DEFINE H2BI_TARGET "win/dos"
 #DEFINE H2BI_BINARY PROG_NAME & ".exe"
#ENDIF

#DEFINE MSG_WELLCOME ? _
  "  This is " & PROG_NAME & " version " & PROG_VERS & NL & _
  "  Copyright (C) 2010-2011 by Thomas.Freiherr{ at }gmx[ dot ]net, License GPLv3" & NL

#DEFINE MSG_VERSION ? _
  "  Compiled: " & __DATE__ & ", " & __TIME__ & " for " & _
  H2BI_TARGET & ". (" & __FB_SIGNATURE__ & ")" & NL

#DEFINE MSG_HELP ? _
  "Command line tool for translating C headers into a FreeBasic .bi header." & NL & NL & _
  "Usage" & NL & _
  "  " & H2BI_BINARY & " [Options] [config-file [config-file2 [config-file3 ...]]]" & NL & NL & _
  "Options:" & NL & _
  "  -h = print this help text and stop" & NL & _
  "  -v = print version information and stop" & NL & _
  "  -f = generate .bi-code as fast as possible" & NL & _
  "  -g = Geany mode, using stdin and stdout streams" & NL & _
  "  -n = use variable names in parameter lists" & NL & _
  "  -t = no use of standard type replacements (only 'void>ANY')" & NL & _
  "  -w = wrap parameter lists" & NL & _
  "  -C = set all options for config file (-Cxx)" & NL & _
  "  -I = set all options for input comments (-Ixx)" & NL & _
  "  -O = set all options for FB code generation (-Oxx)" & NL & _
  "  -P = set single option[s] in textmode (-P_xXx[_xXx[_xXx ...]])" & NL & _
  "  -S = use spaces instead of tab indents ('-S3' = 3 spaces indent)" & NL & NL & _
  "Config-file:" & NL & _
  "  Specify file names without suffix like 'My' (instead of 'My.h2bi')" & NL & _
  "  No file name: FOLDER.h2bi and than " PROG_NAME & ".h2bi will be searched" & NL & _
  "  " & PROG_NAME & " generates empty file on first run, edit file as needed." & NL & _
  "  Result files (*.bi and *_test.bas) will be named after config file" & NL & _
  "  Specify name of C-start-header in first line of config file" & NL & NL & _
  "Example:" & NL & _
  "  " & H2BI_BINARY & " MyFile" & NL & _
  "  1.) Generates MyFile.h2bi on first run and stops." & NL & _
  "  2.) After filling MyFile.h2bi, outputs MyFile.bi and MyFile_Test.bas" & NL & _
  "      will be generated in next run, using default options." & NL & NL & _
  "For details see file 'ReadMe.txt', 'h_2_bi.bi' or visit:" & NL & _
  "  http://www.freebasic-portal.de/downloads/kommandozeilentools/ (de)" & NL & _
  "  http://www.freebasic.net/forum/viewtopic.php?t=15364 (en)" & NL

#INCLUDE ONCE "vbcompat.bi"
#INCLUDE ONCE "h_2_bi.bi" '                 parameter/option definitions
#INCLUDE ONCE "h_2_bi_Helpers.bas" '       div. routines for small tasks
#INCLUDE ONCE "h_2_bi_Options.bas" ' evaluates command line pars/options
#INCLUDE ONCE "h_2_bi_CReader.bas" '             reades C files .h/.h2bi
#INCLUDE ONCE "h_2_bi_Config.bas" '          evaluates config file .h2bi
#INCLUDE ONCE "h_2_bi_Errors.bas" '                       error handling
#INCLUDE ONCE "h_2_bi_FbKwS.bas" '               FreeBasic keyword check
#INCLUDE ONCE "h_2_bi_Macros.bas" '                      macro expansion
#INCLUDE ONCE "h_2_bi_BiWriter.bas" '                    writes .bi file
#INCLUDE ONCE "h_2_bi_Main.bas" '                 translates C header .h

DIM AS H_2_Bi main

END 0
