DIM SHARED AS STRING NL
#IF __FB_UNIX__
 NL = CHR(10)
 #DEFINE DIR_NAME MID(CURDIR, INSTRREV(CURDIR, "/") + 1)
#ELSE
 NL = CHR(13, 10)
 #DEFINE DIR_NAME MID(CURDIR, INSTRREV(CURDIR, "\") + 1)
#ENDIF
#DEFINE TRIMM ANY !" \t\r\n\f\v"
#DEFINE H2BI_FILE_SUFFIX ".h2bi"
#DEFINE BI_FILE_SUFFIX ".bi"
#DEFINE FLAGS_SUFFIX "(){};"
#DEFINE GEANY_FILE "Geany"
#DEFINE TYKENN "_"
'#DEFINE NO_DIM "*???"
#DEFINE NO_DIM "..." ' 3 characters!
#DEFINE FILE_START(_P_) "' " & RIGHT(STR(_P_ + 1000), 3) & " start from: "
#DEFINE FILE_BACK(_P_) "' " & RIGHT(STR(_P_ + 1000), 3) & " back from "

' the following blocks are to define options for '-P_' groups:
' C = config file handling (.h2bi)
' I = input handling (source and comments of .h files)
' O = output handling (FB source generation in .bi)
' P = protocol generation (in .bi)
' T = translations (in .bi)

' how to handle the config file (.h2bi)
' Behandlung der Konfigurationsdatei (wirkt nicht bei aktueller Bearbeitung)
#DEFINE DEFAULT_FLC &hFFFFFFFF
TYPE C_Flags
#DEFINE KEY_START "__START_BI__"
#DEFINE TCST "ST"
  AS UINTEGER ST : 1 ' read start sections
#DEFINE KEY_END "__END_BI__"
#DEFINE TCEN "EN"
  AS UINTEGER EN : 1 ' read end sections
#DEFINE KEY_TYPES "__TYPES__"
#DEFINE TCTY "TY"
  AS UINTEGER TY : 1 ' read types sections
#DEFINE KEY_HEADERS "__HEADERS__"
#DEFINE TCHR "HR"
  AS UINTEGER HR : 1 ' read header sections
#DEFINE KEY_PARAMETERS "__PARAMETERS__"
#DEFINE TCPA "PA"
  AS UINTEGER PA : 1 ' read parameter sections
#DEFINE KEY_FOLDERS "__FOLDERS__"
#DEFINE TCFO "FO"
  AS UINTEGER FO : 1 ' read folder sections
#DEFINE KEY_MACROS "__MACROS__"
#DEFINE TCMA "MA"
  AS UINTEGER MA : 1 ' read macro sections
#DEFINE TCPO "PO"
#DEFINE KEY_POST_REPS "__POST_REPS__"
  AS UINTEGER PO : 1 ' read POST sections
#DEFINE TCDT "DT"
  AS UINTEGER DT : 1 ' use default type replacements
#DEFINE TCDH "DH"
  AS UINTEGER DH : 1 ' use default file replacements
END TYPE

' how to handle the input (.h files)
' Kommentare aus Headerdateien
#DEFINE DEFAULT_FLI &hFFFFFF1F
TYPE I_Flags
  AS UINTEGER RES1 : 1 ' reserved
  AS UINTEGER RES2 : 1 ' reserved
  AS UINTEGER COMM : 1
  AS UINTEGER CODE : 1 ' output y/n (internal use only)
#DEFINE FLI_MASK_CC &b11000000
#DEFINE FLI_MASK_CS &hFFFFFF00
' how to show source and comments
#DEFINE TISC "SC"
  AS UINTEGER SHCC : 1 ' show C comments
#DEFINE TISB "SB"
  AS UINTEGER BLCO : 1 ' show C comments in Blocks
#DEFINE TICS "CS"
  AS UINTEGER CSKO : 1 ' compress C source
#DEFINE TICC "CC"
  AS UINTEGER CCKO : 1 ' compress C comments
' which source to show
#DEFINE TIBE "BE"
  AS UINTEGER BE : 1 ' ENUM blocks
#DEFINE TIBU "BU"
  AS UINTEGER BU : 1 ' UNION blocks
#DEFINE TIBT "BT"
  AS UINTEGER BT : 1 ' TYPE blocks
#DEFINE TITY "TY"
  AS UINTEGER TY : 1 ' TYPE lines
#DEFINE TIDI "DI"
  AS UINTEGER DI : 1 ' DIM lines
#DEFINE TIST "ST"
  AS UINTEGER ST : 1 ' STATIC lines
#DEFINE TICO "CO"
  AS UINTEGER CO : 1 ' CONST lines
#DEFINE TIEX "EX"
  AS UINTEGER EX : 1 ' EXTERN lines
#DEFINE TIDE "DE"
  AS UINTEGER DE : 1 ' DECLARE lines
#DEFINE TIPD "PD"
  AS UINTEGER PD : 1 ' #DEFINE line
#DEFINE TIPE "PE"
  AS UINTEGER PE : 1 ' #ERROR lines
#DEFINE TIPI "PI"
  AS UINTEGER PI : 1 ' #INCLUDE lines
#DEFINE TIPU "PU"
  AS UINTEGER PU : 1 ' #UNDEF lines
#DEFINE TIPX "PX"
  AS UINTEGER PX : 1 ' #IFDEF, #IFNDEF, #IF, #ELSEIF, #ENDIF lines
#DEFINE TICA "CA"
  AS UINTEGER CA : 1 ' all CAST replacements
#DEFINE TIER "ER"
  AS UINTEGER ER : 1 ' all translation with error
#DEFINE TIUT "UT"
  AS UINTEGER UT : 1 ' all untranslated C line(s)
END TYPE

' how to generate output (.bi file)
' Generierung der Ergebnisdatei
#DEFINE DEFAULT_FLO &hFFFFFFFE
TYPE O_Flags
#DEFINE TOAL "AL"
  AS UINTEGER AL : 1 ' use ALIAS for SUBs/FUNCTIONs (off)
#DEFINE TOWR "WR"
  AS UINTEGER WR : 1 ' wrap parameter lists (on)
#DEFINE TONA "NA"
  AS UINTEGER NA : 1 ' use names in parameter lists (on)
#DEFINE TOBV "BV"
  AS UINTEGER BV : 1 ' use BYVAL in parameter lists (on)
#DEFINE TOCD "CD"
  AS UINTEGER CD : 1 ' use CDECL for parameter lists (on)
#DEFINE TONT "NT"
  AS UINTEGER NT : 1 ' "0 TO " in field dimension (on)
#DEFINE TOUD "UD"
  AS UINTEGER UD : 1 ' uncomment unsave #DEFINE lines (on)
#DEFINE TOUC "UC"
  AS UINTEGER UC : 1 ' mark unsave CASTs (on)
#DEFINE TOMF "MF"
  AS UINTEGER MF : 1 ' mark file include (on)
#DEFINE TOMI "MI"
  AS UINTEGER MI : 1 ' mark #else/#endif for #if/#ifdef/#ifndef (on)
#DEFINE TOMB "MB"
  AS UINTEGER MB : 1 ' mark place of untranslated blocks {static inline} (on)
#DEFINE TOER "ER"
  AS UINTEGER ER : 1 ' mark error lines with BIN # (on)
#DEFINE TOET "ET"
  AS UINTEGER ET : 1 ' mark error lines with text instead of BIN# (on)
#DEFINE TOSI "SI"
  AS UINTEGER SI : 1 ' single file output = all-in-one (on)
END TYPE

' how to generate the protocol (end of .bi file)
' Generierung des Protokolls
#DEFINE DEFAULT_FLP &hFFFFFFFF
TYPE P_Flags
#DEFINE TPNA "NA"
  AS UINTEGER NA : 1 ' show name of .bi file (on)
#DEFINE TPPA "PA"
  AS UINTEGER PA : 1 ' show parameters command line/.h2bi file (on)
#DEFINE TPTI "TI"
  AS UINTEGER TI : 1 ' show process time (on)
#DEFINE TPBY "BY"
  AS UINTEGER BY : 1 ' show number of translated bytes (on)
#DEFINE TPDE "DE"
  AS UINTEGER DE : 1 ' show deepness info (on)
#DEFINE TPNS "NS"
  AS UINTEGER NS : 1 ' show number of SUB/FUNCTION names (on)
#DEFINE TPLS "LS"
  AS UINTEGER LS : 1 ' show list of SUB/FUNCTION names (on)
#DEFINE TPNX "NX"
  AS UINTEGER NX : 1 ' show number of mangled TYPE names (on)
#DEFINE TPLX "LX"
  AS UINTEGER LX : 1 ' show list of mangled TYPE names (on)
#DEFINE TPNF "NF"
  AS UINTEGER NF : 1 ' show number of input files (on)
#DEFINE TPLF "LF"
  AS UINTEGER LF : 1 ' show list of input files (on)
#DEFINE TPNY "NY"
  AS UINTEGER NY : 1 ' show number of missed input files (on)
#DEFINE TPLY "LY"
  AS UINTEGER LY : 1 ' show list of missed input files (on)
#DEFINE TPND "ND"
  AS UINTEGER ND : 1 ' show number of FOLDERS (on)
#DEFINE TPLD "LD"
  AS UINTEGER LD : 1 ' show list of FOLDERS (on)
#DEFINE TPNM "NM"
  AS UINTEGER NM : 1 ' show number of MACROS (on)
#DEFINE TPLM "LM"
  AS UINTEGER LM : 1 ' show list of MACROS (on)
#DEFINE TPNH "NH"
  AS UINTEGER NH : 1 ' show number of HEADERS replacements (on)
#DEFINE TPLH "LH"
  AS UINTEGER LH : 1 ' show list of HEADERS replacements (on)
#DEFINE TPNT "NT"
  AS UINTEGER NT : 1 ' show number of TYPES replacements (on)
#DEFINE TPLT "LT"
  AS UINTEGER LT : 1 ' show list of TYPES replacements (on)
#DEFINE TPNP "NP"
  AS UINTEGER NP : 1 ' show number of POST replacements (on)
#DEFINE TPLP "LP"
  AS UINTEGER LP : 1 ' show list of POST replacements (on)
END TYPE

' how to translate, switch single translations (.bi file)
' Welche Uebersetzungen werden generiert
#DEFINE DEFAULT_FLT &hFFFFFFFF
TYPE T_Flags
#DEFINE TTDE "DE"
  AS UINTEGER DE : 1 ' translate DECLARE lines (on)
#DEFINE TTDI "DI"
  AS UINTEGER DI : 1 ' translate DIM lines (on)
#DEFINE TTTY "TY"
  AS UINTEGER TY : 1 ' translate TYPE lines (on)
#DEFINE TTST "ST"
  AS UINTEGER ST : 1 ' translate STATIC lines (on)
#DEFINE TTEX "EX"
  AS UINTEGER EX : 1 ' translate EXTERN lines (on)
#DEFINE TTCO "CO"
  AS UINTEGER CO : 1 ' translate CONST lines (on)
#DEFINE TTBT "BT"
  AS UINTEGER BT : 1 ' translate TYPE blocks (on)
#DEFINE TTBU "BU"
  AS UINTEGER BU : 1 ' translate UNION blocks (on)
#DEFINE TTBE "BE"
  AS UINTEGER BE : 1 ' translate ENUM blocks (on)
#DEFINE TTPD "PD"
  AS UINTEGER PD : 1 ' translate preprocessor define (on)
#DEFINE TTPE "PE"
  AS UINTEGER PE : 1 ' translate preprocessor error (on)
#DEFINE TTPI "PI"
  AS UINTEGER PI : 1 ' translate preprocessor include (on)
#DEFINE TTPU "PU"
  AS UINTEGER PU : 1 ' translate preprocessor undef (on)
#DEFINE TTPX "PX"
  AS UINTEGER PX : 1 ' translate preprocessor if/else (on)
#DEFINE TTCS "CS"
  AS UINTEGER CS : 1 ' translate save CAST (on)
#DEFINE TTCU "CU"
  AS UINTEGER CU : 1 ' translate unsave CASTs (on)
#DEFINE TTII "II"
  AS UINTEGER II : 1 ' translate IIFS (on)
#DEFINE TTQU "QU"
  AS UINTEGER QU : 1 ' translate quotes: '', "" (on)
#DEFINE TTLO "LO"
  AS UINTEGER LO : 1 ' translate logic: &&, >>, |, ... (on)
#DEFINE TTUT "UT"
  AS UINTEGER UT : 1 ' use '_' extension for 'typedef a a;' (on)
#DEFINE TTUV "UV"
  AS UINTEGER UV : 1 ' use '_' for unnamed vars (on)
#DEFINE TTKW "KW"
  AS UINTEGER KW : 1 ' use '_' for extension FB keywords (on)
#DEFINE TTAN "AN"
  AS UINTEGER AN : 1 ' declare TYPEs without C type as ANY PTR (on)
#DEFINE TTMA "MA"
  AS UINTEGER MA : 1 ' expand macros recursivly (on)
#DEFINE TTPT "PT"
  AS UINTEGER PT : 1 ' PTR removing for SUBs/FUNCTIONs (on)
END TYPE
