' This is file h_2_bi_Config.bas
' (C) 2010-2011 by TJF, GPLv3
' It's part of 'h_2_bi.bas' package, see for details:
' http://www.freebasic.net/forum/viewtopic.php?t=15364&postdays=0&postorder=asc&start=0

TYPE Config
  DECLARE CONSTRUCTOR(BYVAL I AS CFileReader PTR, BYVAL O AS Options PTR)
  AS STRING FNams ' Names startheaders
  AS STRING Msg   ' messages, errors
  AS STRING CoLi  ' command line parameters/options
  AS STRING Start ' Start section
  AS STRING Ende  ' End section
  AS STRING Fold = STACK_NEW   ' Folders
  AS STRING Macros = STACK_NEW ' Macros text
  AS INTEGER AzTy ' number TYPES reps
  AS INTEGER AzHe ' number HEADERS reps
  AS RepData Head ' Headers
  AS RepData Typ_ ' Type replacements
  AS RepData Post ' Post translation replacements
Private:
  AS CFileReader PTR In
  AS Options PTR Op
  DECLARE SUB addMacro()
  DECLARE SUB addFold()
  DECLARE SUB addType()
  DECLARE SUB addHead()
  DECLARE SUB addPost()
  DECLARE SUB addDefTypes()
  DECLARE SUB addDefHeaders()
END TYPE

CONSTRUCTOR Config(BYVAL I AS CFileReader PTR, BYVAL O AS Options PTR)
  In = I
  Op = O
  Typ_.add("void ", "ANY")
  DIM AS UBYTE mo = 0
  Msg &= "Config-file: " & In->FNam & NL
  WHILE In->weGo()
    In->readLine()
    VAR z = RTRIM(In->Tex, TRIMM)
    IF LEN(z) ORELSE mo >= 7 THEN
      IF RIGHT(z, 5) = FLAGS_SUFFIX THEN
        SELECT CASE nextWord(z)
        CASE KEY_TYPES      : mo = 1
        CASE KEY_FOLDERS    : mo = 2
        CASE KEY_HEADERS    : mo = 3
        CASE KEY_POST_REPS  : mo = 4
        CASE KEY_MACROS     : mo = 5
        CASE KEY_PARAMETERS : mo = 6
        CASE KEY_START      : mo = 7
        CASE KEY_END        : mo = 8
        CASE ELSE : Msg &= "Unknown section in " & In->FNam & ": " & z & NL
        END SELECT
      ELSE
        IF mo < 7 THEN z = LTRIM(z, TRIMM)
        SELECT CASE AS CONST mo
        CASE 0 : IF LEN(z) THEN FNams += z & ";"
        CASE 1 : IF Op->C.TY THEN addType()
        CASE 2 : IF Op->C.FO THEN addFold()
        CASE 3 : IF Op->C.HR THEN addHead()
        CASE 4 : IF Op->C.PO THEN addPost()
        CASE 5 : IF Op->C.MA THEN addMacro()
        CASE 6 : IF Op->C.PA THEN CoLi &= " " & z
        CASE 7 : IF Op->C.ST THEN Start += z & NL
        CASE 8 : IF Op->C.EN THEN Ende += z & NL
        CASE ELSE : Msg &= "Error line in " & In->FNam & " :" & NL & z & NL
        END SELECT
      END IF
    END IF : In->newTex()
  WEND : Start = TRIM(Start, TRIMM) : Ende = TRIM(Ende, TRIMM)
  CoLi = TRIM(CoLi, TRIMM) & " " & TRIM(Op->Options, TRIMM)
  IF LEN(CoLi) > 1 THEN Op->checkOption(CoLi, 0, LEN(CoLi) - 1) : Msg &= Op->Msg
  IF Op->C.DT THEN addDefTypes()
  IF Op->C.DH THEN addDefHeaders()
END CONSTRUCTOR

' adds a new basic source replacement
' speichert ein neues Suchwort zur Ersetzung im Basic-Text
SUB Config.addPost()
  VAR p = INSTR(In->Tex, ">")
  IF p = 0 THEN p = INSTR(In->Tex, "&") :  IF p = 0 THEN EXIT SUB
  VAR se = TRIM(LEFT(In->Tex, p - 1), TRIMM)
  VAR re = MID(In->Tex, p + 1)
  IF In->Tex[p - 1] = ASC("&") THEN
    IF LEN(re) = 0 THEN re = TYKENN
    re = se & TRIM(re, TRIMM)
  END IF : VAR r = Post.add(se, re)
  IF r THEN Msg &= KEY_POST_REPS & ": '" & se & "' " & *r & NL
END SUB

' adds a new type for replacement
' speichert einen neuen Typ fuer die Uebersetzung
SUB Config.addType()
  VAR p = INSTR(In->Tex, ">") : IF p = 0 THEN EXIT SUB
  VAR se = TRIM(LEFT(In->Tex, p - 1), TRIMM)
  VAR r = Typ_.add(se, MID(In->Tex, p + 1))
  IF r THEN Msg &= KEY_TYPES & ": '" & se & "' " & *r & NL
END SUB

' adds a new filename for replacement
' speichert einen neuen Dateinamen zur Ersetzung bei #include
SUB Config.addHead()
  VAR p = INSTR(In->Tex, ">") : IF p = 0 THEN EXIT SUB
  VAR se = TRIM(LEFT(In->Tex, p - 1), TRIMM)
  VAR r = Head.add(se, MID(In->Tex, p + 1))
  IF r THEN Msg &= KEY_HEADERS & ": '" & se & "' " & *r & NL
END SUB

' adds a new path
' speichert einen neuen Zugriffspfad fuer die Dateisuche
SUB Config.addFold()
  IF INSTR(RIGHT(In->Tex, 1), ANY "/\") = 0 THEN In->Tex &= "/"
  STACK_ADD(Fold, In->Tex)
END SUB

' reads macro, stores context, returns error message
' liest Macro und speichert den Inhalt, liefert ggf. Fehlermeldung
SUB Config.addMacro()
  VAR lt = LEN(In->Tex) - 1 : IF lt < 0 THEN EXIT SUB
  VAR i = skipTrenn(In->Tex, 0, lt)
  IF In->Tex[i] <> ASC("#") THEN _
    Msg &= "no '#' character in macro line:" & NL & In->Tex & NL : EXIT SUB
  IF nextWord(In->Tex, i) <> "define" THEN _
    Msg &= "no define symbol in macro line:" & NL & In->Tex & NL : EXIT SUB
  IF i > lt THEN Msg &= "no macro:" & NL & In->Tex & NL : EXIT SUB
  STACK_ADD(Macros, "#define " & TRIM(MID(In->Tex, i + 2), TRIMM))
END SUB

' defines standard headers
' definiert die Standard-Header
SUB Config.addDefHeaders()
  AzHe = Head.az()
  Head.add(  "wchar.h", "crt/wchar.bi")
  Head.add( "unistd.h", "crt/unistd.bi")
  Head.add(   "time.h", "crt/time.bi")
  Head.add( "string.h", "crt/string.bi")
  Head.add( "stdlib.h", "crt/stdlib.bi")
  Head.add(  "stdio.h", "crt/stdio.bi")
  Head.add( "stdint.h", "crt/stdint.bi")
  Head.add( "stddef.h", "crt/stddef.bi")
  Head.add( "stdarg.h", "crt/stdarg.bi")
  Head.add( "setjmp.h", "crt/setjmp.bi")
  Head.add("process.h", "crt/process.bi")
  Head.add(  "netdb.h", "crt/netdb.bi")
  Head.add(   "math.h", "crt/math.bi")
  Head.add( "malloc.h", "crt/malloc.bi")
  Head.add( "limits.h", "crt/limits.bi")
  Head.add(     "io.h", "crt/io.bi")
  Head.add(  "fcntl.h", "crt/fcntl.bi")
  Head.add(  "errno.h", "crt/errno.bi")
  Head.add(    "dir.h", "crt/dir.bi")
  Head.add(  "ctype.h", "crt/ctype.bi")
  Head.add( "sys/select.h", "crt/sys/select.bi")
  Head.add( "sys/socket.h", "crt/sys/socket.bi")
  Head.add(   "sys/stat.h", "crt/sys/stat.bi")
  Head.add(   "sys/time.h", "crt/sys/time.bi")
  Head.add(  "sys/types.h", "crt/sys/types.bi")
  Head.add(    "sys/uio.h", "crt/sys/uio.bi")

  Head.add("windows.h", "windows.bi")

  Head.add(              "gmodule.h", "gmodule.bi")
  Head.add("gdk-pixbuf/gdk-pixbuf.h", "gtk/gdk-pixbuf/gdk-pixbuf.bi")
  Head.add(              "gdk/gdk.h", "gtk/gdk.bi")
  Head.add(              "atk/atk.h", "atk/atk.bi")
  Head.add(              "gtk/gtk.h", "gtk/gtk.bi")
  Head.add(                 "glib.h", "glib.bi")
  Head.add(              "gio/gio.h", "gio/gio.bi")
  Head.add(          "glib-object.h", "glib-object.bi")
  Head.add(     "pango/pangocairo.h", "pango/pangocairo.bi")
  Head.add(          "pango/pango.h", "pango/pango.bi")
  Head.add(                "cairo.h", "cairo.bi")
  Head.add(              "libintl.h", "libintl.bi")
END SUB

' defines standard types (mind order)
' definiert die Standard-Typen (Reihenfolge beachten)
SUB Config.addDefTypes()
  AzTy = Typ_.az()
  Typ_.add(                "static ", "STATIC")
  Typ_.add(                 "const ", "CONST")
  Typ_.add(           "signed char ", "BYTE")
  Typ_.add(         "unsigned char ", "UBYTE")
  Typ_.add(                  "char ", "ZSTRING")
  Typ_.add(      "signed short int ", "SHORT")
  Typ_.add(          "signed short ", "SHORT")
  Typ_.add(    "unsigned short int ", "USHORT")
  Typ_.add(        "unsigned short ", "USHORT")
  Typ_.add(             "short int ", "SHORT")
  Typ_.add(                 "short ", "SHORT")
  Typ_.add("unsigned long long int ", "ULONGINT")
  Typ_.add(    "unsigned long long ", "ULONGINT")
  Typ_.add(     "unsigned long int ", "ULONGINT")
  Typ_.add(  "signed long long int ", "LONGINT")
  Typ_.add(      "signed long long ", "LONGINT")
  Typ_.add(       "signed long int ", "LONGINT")
  Typ_.add(         "unsigned long ", "UINTEGER")
  Typ_.add(           "signed long ", "INTEGER")
  Typ_.add(            "long float ", "DOUBLE")
  Typ_.add(                 "float ", "SINGLE")
  Typ_.add(           "long double ", "DOUBLE")
  Typ_.add(                "double ", "DOUBLE")
  Typ_.add(             "long long ", "LONGINT")
  Typ_.add(              "long int ", "LONGINT")
  Typ_.add(                  "long ", "INTEGER")
  Typ_.add(            "signed int ", "INTEGER")
  Typ_.add(          "unsigned int ", "UINTEGER")
  Typ_.add(                   "int ", "INTEGER")
  Typ_.add(              "unsigned ", "UNSIGNED")
  Typ_.add(                 "union ", "")
  Typ_.add(                  "enum ", "")
  Typ_.add(                 "class ", "")
  Typ_.add(                "extern ", "")
  Typ_.add(                "struct ", "")
  Typ_.add(              "volatile ", "")
END SUB
