' This is file h_2_bi_Errors.bas
' (C) 2010-2011 by TJF, GPLv3
' It's part of 'h_2_bi.bas' package, see for details:
' http://www.freebasic.net/forum/viewtopic.php?t=15364&postdays=0&postorder=asc&start=0

TYPE E_Flags
  AS UINTEGER NOTY : 1
#DEFINE TENOTY "no type"
  AS UINTEGER NONA : 1
#DEFINE TENONA "no name"
#DEFINE SHIFT_SUFU 2
  AS UINTEGER SFTY : 1
#DEFINE TESFTY "no type for FUNC"
  AS UINTEGER SFNA : 1
#DEFINE TESFNA "no name for SUB/FUNC"
#DEFINE SHIFT_PARA 4
  AS UINTEGER PATY : 1
#DEFINE TEPATY "no type in parameter list"
  AS UINTEGER PANA : 1
#DEFINE TEPANA "no name in parameter list"
  AS UINTEGER NODI : 1
#DEFINE TENODI "dimensioning"
  AS UINTEGER NOMN : 1
#DEFINE TENOMN "no macro name"
  AS UINTEGER CHNA : 1
#DEFINE TECHNA "unknown character in SUB/FUNC name"
  AS UINTEGER USCA : 1
#DEFINE TEUSCA "unsave CAST"
  AS UINTEGER USDE : 1
#DEFINE TEUSDE "unsave DEFINE line(s)"
  AS UINTEGER PANR : 1
#DEFINE TEPANR "parameter# (macro)"
  AS UINTEGER ISMA : 1
#DEFINE TEISMA "macro expansion"
  AS UINTEGER NOIN : 1
#DEFINE TENOIN "init not allowed"
  AS UINTEGER UNDE : 1
#DEFINE TEUNDE "unsupported definition"
  AS UINTEGER USDI : 1
#DEFINE TEUSDI "unsave dimension (string)"
  'AS UINTEGER BLOC : 1
'#DEFINE TEBLOC "unknown block structure in BlockTyUn"
END TYPE

TYPE ErrorHandler
  UNION
    AS UINTEGER FLE
    AS E_Flags E
  END UNION
  DECLARE CONSTRUCTOR (BYVAL A AS INTEGER)
  DECLARE FUNCTION show() AS STRING
  DECLARE SUB shift(BYVAL Bi AS INTEGER)
Private:
  AS INTEGER Art
END TYPE

CONSTRUCTOR ErrorHandler(BYVAL A AS INTEGER)
  Art = A
END CONSTRUCTOR

' generates error message to append on basic source (no or text)
' erzeugt Fehlermeldung zum Anhaengen an Basic Quelltext
FUNCTION ErrorHandler.show() AS STRING
  IF FLE = 0 THEN RETURN ""
  IF Art = 0 THEN FLE = 0 : RETURN ""
  VAR r = "", s = ", "
  IF Art = 1 THEN
    r = BIN(FLE)
  ELSE
    IF E.NOTY THEN r &= s & TENOTY
    IF E.NONA THEN r &= s & TENONA
    IF E.NODI THEN r &= s & TENODI
    IF E.NOMN THEN r &= s & TENOMN
    IF E.PATY THEN r &= s & TEPATY
    IF E.PANA THEN r &= s & TEPANA
    IF E.SFTY THEN r &= s & TESFTY
    IF E.SFNA THEN r &= s & TESFNA
    IF E.CHNA THEN r &= s & TECHNA
    'IF E.BLOC THEN r &= s & TEBLOC
    IF E.USCA THEN r &= s & TEUSCA
    IF E.USDI THEN r &= s & TEUSDI
    IF E.USDE THEN r &= s & TEUSDE
    IF E.UNDE THEN r &= s & TEUNDE
    IF E.PANR THEN r &= s & TEPANR
    IF E.ISMA THEN r &= s & TEISMA
    IF E.NOIN THEN r &= s & TENOIN
    r = LTRIM(r, s)
  END IF: FLE = 0 : RETURN " '??? " & r
END FUNCTION

' moves error bits for SUB/FUNC and ParaList
SUB ErrorHandler.shift(BYVAL Bi AS INTEGER)
  FLE = (FLE AND &hFFFFFFFC) OR ((FLE AND &b11) SHL Bi)
END SUB
