' This is file h_2_bi_Options.bas
' (C) 2010-2011 by TJF, GPLv3
' It's part of 'h_2_bi.bas' package, see for details:
' http://www.freebasic.net/forum/viewtopic.php?t=15364&postdays=0&postorder=asc&start=0

TYPE Options
  AS STRING Jobs, Msg, Options
  'AS INTEGER RunMod, Art_Co, Tabs = -1
  AS INTEGER RunMod, Tabs = -1
  UNION
    AS C_Flags C
    AS UINTEGER FLC
  END UNION
  UNION
    AS I_Flags I
    AS UINTEGER FLI
  END UNION
  UNION
    AS O_Flags O
    AS UINTEGER FLO
  END UNION
  UNION
    AS P_Flags P
    AS UINTEGER FLP
  END UNION
  UNION
    AS T_Flags T
    AS UINTEGER FLT
  END UNION
  DECLARE CONSTRUCTOR(BYREF Li AS STRING)
  DECLARE SUB checkOption(BYREF Li AS STRING, BYREF I AS INTEGER, BYVAL Lt AS INTEGER)
Private:
  DECLARE FUNCTION checkOptP(BYREF Li AS STRING, BYVAL k AS INTEGER, BYVAL Lt AS INTEGER) AS INTEGER
END TYPE

CONSTRUCTOR Options(BYREF Li AS STRING)
  FLC = DEFAULT_FLC
  FLI = DEFAULT_FLI
  FLO = DEFAULT_FLO
  FLP = DEFAULT_FLP
  FLT = DEFAULT_FLT
  VAR lt = LEN(Li) - 1
  FOR i AS INTEGER = 0 TO lt '                           COMMAND checken
    SELECT CASE AS CONST CHAR_TYP[Li[i]]
    CASE 13 : VAR p = i + 1
      checkOption(Li, i, lt) : Options = " " & MID(Li, p) : EXIT FOR
    CASE 15, 17
    CASE ELSE
      VAR j = INSTR(i + 2, Li, " ") - 1 : IF j < 0 THEN j = lt + 1
      Jobs &= MID(Li, i + 1, j - i) & CHR(1)
      i = j
    END SELECT
  NEXT
END CONSTRUCTOR

' checks parameters from command line at start/from .h2bi
' prueft die Parameter beim Programmaufruf bzw. aus .h2bi
SUB Options.checkOption(BYREF Li AS STRING, BYREF A AS INTEGER, BYVAL Lt AS INTEGER)
  DO
    A += 1 : IF A > lt THEN EXIT SUB
    SELECT CASE AS CONST Li[A]
    CASE ASC("O") : FLO = getNumber(Li, A, Lt)
    CASE ASC("I") : FLI = getNumber(Li, A, Lt)
    CASE ASC("C") : FLC = getNumber(Li, A, Lt)
    CASE ASC("P") : A = checkOptP(Li, A, Lt)
    CASE ASC("S") : Tabs = getNumber(Li, A, Lt)
    CASE ASC("n") : O.NA = 1
    CASE ASC("w") : O.WR = 1
    CASE ASC("t") : C.DT = 1
    CASE ASC("g") : RunMod OR= 1
    CASE ASC("v") : RunMod OR= 2
    CASE ASC("h") : RunMod OR= 3
    CASE ASC("f") : FLI = 0 : I.ER = 1 : P.LS = 0
      FLO = &hFFFFFFFF
      O.WR = 0 : O.NA = 0 : O.CD = 0 : O.NT = 0 : O.MB = 0 : O.AL = 0 : O.ET = 1
    CASE ASC("-"), ASC(" ")
    CASE ELSE : Msg & = "Ignoring unknown option: " & CHR(Li[A]) & NL
    END SELECT
  LOOP
END SUB

' checks parameters from command line at start
' prueft die Parameter beim Programmaufruf
FUNCTION Options.checkOptP(BYREF Li AS STRING, BYVAL k AS INTEGER, BYVAL Lt AS INTEGER) AS INTEGER
  FOR j AS INTEGER = k + 1 TO Lt
    IF Li[j] <> ASC("_") THEN RETURN j
    VAR w = ""
    WHILE j < Lt
      j += 1
      IF CHAR_TYP[Li[j]] = 2 ORELSE _
         CHAR_TYP[Li[j]] = 1 THEN w += CHR(Li[j]) ELSE j -= 1 : EXIT WHILE
    WEND : IF LEN(w) = 0 THEN Msg &= "Missing -P option (behind '_')!" & NL : RETURN j
    VAR f = IIF(CHAR_TYP[w[0]] = 1, 1, 0)
    SELECT CASE AS CONST w[0]
    CASE ASC("c"), ASC("C")
      SELECT CASE UCASE(MID(w, 2))
      CASE TCST : C.ST = f
      CASE TCEN : C.EN = f
      CASE TCTY : C.TY = f
      CASE TCHR : C.HR = f
      CASE TCPA : C.PA = f
      CASE TCFO : C.FO = f
      CASE TCMA : C.MA = f
      CASE TCPO : C.PO = f
      CASE TCDT : C.DT = f
      CASE TCDH : C.DH = f
      CASE ELSE : Msg &= "Ignoring unknown -P option: " & w  & NL: CONTINUE FOR
      END SELECT
    CASE ASC("i"), ASC("I")
      SELECT CASE UCASE(MID(w, 2))
      CASE "ALL" : IF f THEN FLI OR= &hFFFFFF00 ELSE FLI AND= &hFF
      CASE TISC : I.SHCC = f
      CASE TISB : I.BLCO = f
      CASE TICS : I.CSKO = f
      CASE TICC : I.CCKO = f
      CASE TITY : I.TY = f
      CASE TIDI : I.DI = f
      CASE TIST : I.ST = f
      CASE TICO : I.CO = f
      CASE TIEX : I.EX = f
      CASE TIDE : I.DE = f
      CASE TIBE : I.BE = f
      CASE TIBU : I.BU = f
      CASE TIBT : I.BT = f
      CASE TIPD : I.PD = f
      CASE TIPE : I.PE = f
      CASE TIPI : I.PI = f
      CASE TIPU : I.PU = f
      CASE TIPX : I.PX = f
      CASE TICA : I.CA = f
      CASE TIER : I.ER = f
      CASE TIUT : I.UT = f
      CASE ELSE : Msg &= "Ignoring unknown -P option: " & w  & NL: CONTINUE FOR
      END SELECT
    CASE ASC("o"), ASC("O")
      SELECT CASE UCASE(MID(w, 2))
      CASE TOWR : O.WR = f
      CASE TONA : O.NA = f
      CASE TOBV : O.BV = f
      CASE TOCD : O.CD = f
      CASE TOAL : O.AL = f
      CASE TONT : O.NT = f
      CASE TOUC : O.UC = f
      CASE TOUD : O.UD = f
      CASE TOMF : O.MF = f
      CASE TOMI : O.MI = f
      CASE TOER : O.ER = f
      CASE TOET : O.ET = f
      CASE TOMB : O.MB = f
      CASE TOSI : O.SI = f
      CASE ELSE : Msg &= "Ignoring unknown -P option: " & w  & NL: CONTINUE FOR
      END SELECT
    CASE ASC("p"), ASC("P")
      SELECT CASE UCASE(MID(w, 2))
      CASE TPNA : P.NA = f
      CASE TPPA : P.PA = f
      CASE TPTI : P.TI = f
      CASE TPBY : P.BY = f
      CASE TPDE : P.DE = f
      CASE TPNS : P.NS = f
      CASE TPLS : P.LS = f
      CASE TPNX : P.NX = f
      CASE TPLX : P.LX = f
      CASE TPNF : P.NF = f
      CASE TPLF : P.LF = f
      CASE TPNY : P.NY = f
      CASE TPLY : P.LY = f
      CASE TPNM : P.NM = f
      CASE TPLM : P.LM = f
      CASE TPND : P.ND = f
      CASE TPLD : P.LD = f
      CASE TPNH : P.NH = f
      CASE TPLH : P.LH = f
      CASE TPNT : P.NT = f
      CASE TPLT : P.LT = f
      CASE TPNP : P.NP = f
      CASE TPLP : P.LP = f
      CASE ELSE : Msg &= "Ignoring unknown -P option: " & w & NL
      END SELECT
    CASE ASC("t"), ASC("T")
      SELECT CASE UCASE(MID(w, 2))
      CASE TTDE : T.DE = f
      CASE TTDI : T.DI = f
      CASE TTTY : T.TY = f
      CASE TTST : T.ST = f
      CASE TTEX : T.EX = f
      CASE TTCO : T.CO = f
      CASE TTBT : T.BT = f
      CASE TTBU : T.BU = f
      CASE TTBE : T.BE = f
      CASE TTPD : T.PD = f
      CASE TTPE : T.PE = f
      CASE TTPI : T.PI = f
      CASE TTPU : T.PU = f
      CASE TTPX : T.PX = f
      CASE TTMA : T.MA = f
      CASE TTCS : T.CS = f
      CASE TTCU : T.CU = f
      CASE TTII : T.II = f
      CASE TTQU : T.QU = f
      CASE TTUT : T.UT = f
      CASE TTLO : T.LO = f
      CASE TTAN : T.AN = f
      CASE TTUV : T.UV = f
      CASE TTKW : T.KW = f
      CASE TTPT : T.PT = f
      CASE ELSE : Msg &= "Ignoring unknown -P option: " & w & NL
      END SELECT
    CASE ELSE : Msg &= "Ignoring unknown -P option: " & w & NL
    END SELECT
  NEXT : RETURN Lt
END FUNCTION
